cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      program vel2gadget
c Compute particle positions from velocities
c and write a gadget file.
c ---------------------------------------------
c 
c Particle positions follow from velocities:
c In the Zeldovic approximation, the  displacements from the 
c unperturbed positions are proportional to the peculiar velocities.
c 
c Warning: cube size limited by maxsize, memory usage > 4*maxsize^3*sizeof(real)  !!
c 
c Input: uses 3 files from grafic2 (6 files if baryons are also included):
c     ic_velcx,ic_velcy,ic_velcz
c     (ic_velbx,ic_velby,ic_velbz)
c
c Output: gadget file, with massarr(0,1) != 0 
c
c Algorithm:
c 1. open the ic_vel* files
c 2. write tipsy header
c 3. foreach ref slices of cube
c     3.1. read ic_velcx
c     3.2. calculate and store x components of the positions
c     3.2. same for y and z
c     3.4. write ordered** tipsy output 
c      (x,y,z,vx,vy,vz,..) of all particles of these slices 
c     end foreach
c


c      implicit none
      integer*8 tmp
      integer i1,i2,i3, np0,n1,n2,n3,ref,r,nSlice,slice
      parameter (maxsize = 150) !2024
      parameter(maxsize2 = 2*maxsize**3)
      parameter (maxref = 200)
      integer k1,k2,k3,j1,j2,IAS,nsph
      real velx(maxsize,maxsize,maxref)
      real vely(maxsize,maxsize,maxref)
      real velz(maxsize,maxsize,maxref)
      real x(maxsize,maxsize,maxref)
      real y(maxsize,maxsize,maxref)
      real z(maxsize,maxsize,maxref)
      real velxc(maxsize,maxsize,maxref)
      real velyc(maxsize,maxsize,maxref)
      real velzc(maxsize,maxsize,maxref)
      real xc(maxsize,maxsize,maxref)
      real yc(maxsize,maxsize,maxref)
      real zc(maxsize,maxsize,maxref)
      real dx,dx0,x1o,x2o,x3o,xcorr,ycoor,zcorr,eps
      double precision x0,y0,z0,offset,vfact
      double precision timeS,lengthM,v2tFact,p2tFact
      real astart,omegam,omegav,h0
      real omegab,rho,temp,hsmooth,metals 

c     my variables Andrea
      integer i,j,k
      real Lbox,rho_crit,hsmall


c     Gadget variables

      integer*4 npart(0:5), nall(0:5)
      real*8    massarr(0:5)
      real*8    time
      real*8    redshift
      integer*4 unused(24) 
      integer*4 nstart,flag_sfr,flag_feedback
      integer*4 N,Ntot
      real*8 Boxsize
      real*8 OmegaMatter
      real*8 OmegaLambda,HubbleParam
      real*4  pos(3,maxsize2),vel(3,maxsize2)
      integer*4 id(maxsize2)
      real*4 mass(maxsize2)
      real*4 u(maxsize2/2)

c     external fomega,dladt,ofilew,wtheader,wtdark,wtgas,cfile
      character *30 outfile
 

     
c      outfile='snapshot.000' 
c     
      print*,'Enter top grid spacing in Mpc'
      read(*,*) dx0
      print*,'Enter top grid size' 
      read(*,*) np0
c      print*,'Enter softening in L=1 units'
c      read(*,*) eps
      print*,'Enter output file name'
      read(*,*) outfile
      print*,'Enter refinement factor' !=1 for no refinements
      read(*,*) ref
      print*,'Enter Omega_baryons? type 0 for pure CDM simulations'
      read(*,*) omegab
c
c     open ic_velc* files and read headers
c



      open(10,file='ic_velcx' ,form='unformatted')
      rewind 10
      read(10) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      open(11,file='ic_velcy' ,form='unformatted')
      rewind 11
      read(11) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      open(12,file='ic_velcz' ,form='unformatted')
      rewind 12
      read(12) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0

      print *,'grid size ',n1,n2,n3
      print *,'dx0 ',dx0
      print *,'h0 ',h0

c  calculate units where G = M_cube = rho_crit = 1
c      lengthM = np0 * dx0 * 3.0857E22
c      timeS = sqrt(8.0*3.1416/3.0) * 3.0857E19/h0 
c      v2tFact = 1000 * timeS/(astart * lengthM)

c conversions form proper km/s and Mpc to new units.
c      p2tFact = 3.0857E22 / lengthM
       nSlice = n3/ref
c      tmp = ref**3
c      tmp = tmp*np0**3


c     calculate GADGET units
      rho_crit= 2.775e11 !Msun/Mpc^3 *h^2
      hsmall = h0/100.0
      Lbox = dx0*n1*hsmall
      print*,'Lbox Mpc/h', Lbox
      massarr(1) = (Lbox/float(n1))**3*(omegam-omegab)*rho_crit
      massarr(1) = massarr(1)/1.0e10
c     
      if(ref.gt.maxref) then 
         print *,'ERROR: refinement factor exceeds limit!'
      end if
      if(n1.gt.maxsize) then 
         print *,'ERROR: n1 factor exceeds limit!'
      end if
      if(n2.gt.maxsize) then 
         print *,'ERROR: n2 factor exceeds limit!'
      end if
      if(n3.gt.maxsize) then 
         print *,'ERROR: n3 factor exceeds limit!'
      end if
      
c      print *,'v2tFact', v2tFact
c      print *,'p2tFact', p2tFact
c      print *,'nSlice ',nSlice
      print *,'ref ',ref
      print *,'dx ',dx
c write tipsy header


      massarr(0) = 0
      do i=0,5
         npart(i) = 0
         nall(i) = 0
      enddo

      nbar = 0
      if(omegab.ne.0) then

         massarr(0) = (Lbox/float(n1))**3*omegab*rho_crit
         massarr(0) = massarr(0)/1.0e10

      open(14,file='ic_velbx' ,form='unformatted')
      rewind 14
      read(14) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      open(15,file='ic_velby' ,form='unformatted')
      rewind 15
      read(15) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      open(16,file='ic_velbz' ,form='unformatted')
      rewind 16
      read(16) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      print *,'baryon offset ', x1o, ' ', x2o, ' ', x3o 


      npart(0)= n1*n2*n3
      nall(0) = nall(0) + npart(0)


c     velocity (proper km/s) =  Displacement (comoving Mpc at astart) * vfact.
c     vfact = dln(D+)/dtau where tau=conformal time.
c     These functions (fomega, dladt) are in time.f, so link them.
      vfact = fomega(astart,omegam,omegav)
     &     *h0 * dladt(astart,omegam,omegav)/astart
c     Offset the positions so that the (dx0/dx)**3 particles corresponding
c     to one level_0 particle are centered on the level_0 particle.
      offset=0.5*(dx0-dx)

      print*,'vfact ',vfact
      print*,'offset ',offset

c   Read ref slices of the x velocity field.
      nbar = 0 
      do i3=1,n3
         read(14) ((velx(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               x0=(i1-1)*dx + offset
               nbar = nbar +1  
               x(i1,i2,i3)=x0+velx(i1,i2,i3)/vfact
               pos(1,nbar)=(x0+velx(i1,i2,i3)/vfact)*hsmall
               if(pos(1,nbar).lt.0) pos(1,nbar) = pos(1,nbar)+Lbox
               if(pos(1,nbar).gt.Lbox) pos(1,nbar) = pos(1,nbar)-Lbox
               pos(1,nbar) = 1000.0 * pos(1,nbar)
               vel(1,nbar)= velx(i1,i2,i3)
            end do
         end do
      end do
c     Read ref slices of the y velocity field.
      nbar = 0 
      do i3=1,n3
         read(15) ((vely(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               y0=(i2-1)*dx + offset
               nbar = nbar + 1 
               y(i1,i2,i3)=y0+vely(i1,i2,i3)/vfact
               pos(2,nbar)=(y0+vely(i1,i2,i3)/vfact)*hsmall
               if(pos(2,nbar).lt.0) pos(2,nbar) = pos(2,nbar)+Lbox
               if(pos(2,nbar).gt.Lbox) pos(2,nbar) = pos(2,nbar)-Lbox
               pos(2,nbar) = 1000.0 * pos(2,nbar)
               vel(1,nbar)= vely(i1,i2,i3)
            end do
         end do
      end do
c     Read ref slices of the z velocity field.
      nbar = 0 
      do i3=1,n3
         read(16) ((velz(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               z0=(i3-1)*dx + offset
               nbar = nbar +1
               z(i1,i2,i3)=z0+velz(i1,i2,i3)/vfact
               pos(3,nbar)=(z0+velz(i1,i2,i3)/vfact)*hsmall
               if(pos(3,nbar).lt.0) pos(3,nbar) = pos(3,nbar)+Lbox
               if(pos(3,nbar).gt.Lbox) pos(3,nbar) = pos(3,nbar)-Lbox
               pos(3,nbar) = 1000.0 * pos(3,nbar)
               vel(3,nbar)= velz(i1,i2,i3)
            end do
         end do
      end do

      close(14)
      close(15)
      close(16)
      end if !on omega_b

c     read DARK particles:

      rewind 10
      read(10) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      rewind 11
      read(11) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      rewind 12
      read(12) n1,n2,n3,dx,x1o,x2o,x3o,astart,omegam,omegav,h0
      
c     velocity (proper km/s) =  Displacement (comoving Mpc at astart) * vfact.
c     vfact = dln(D+)/dtau where tau=conformal time.
c     These functions (fomega, dladt) are in time.f, so link them.
      vfact = fomega(astart,omegam,omegav)
     &     *h0 * dladt(astart,omegam,omegav)/astart
c     Offset the positions so that the (dx0/dx)**3 particles corresponding
c     to one level_0 particle are centered on the level_0 particle.
      offset=0.5*(dx0-dx)

      npart(1) = n1*n2*n3
      nall(1) = nall(1) + npart(1)

c   Read ref slices of the x velocity field.
      ncold = nbar
      do i3=1,n3
         read(10) ((velxc(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               x0=(i1-1)*dx + offset
               ncold = ncold +1
               xc(i1,i2,i3)=x0+velxc(i1,i2,i3)/vfact
               pos(1,ncold)=(x0+velxc(i1,i2,i3)/vfact)*hsmall
               if(pos(1,ncold).lt.0) pos(1,ncold) = pos(1,ncold)+Lbox
               if(pos(1,ncold).gt.Lbox) pos(1,ncold) = pos(1,ncold)-Lbox
               pos(1,ncold) = 1000.0 * pos(1,ncold)
               vel(1,ncold)= velxc(i1,i2,i3)
            end do
         end do
      end do
c     Read ref slices of the y velocity field.
      ncold = nbar 
      do i3=1,n3
         read(11) ((velyc(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               y0=(i2-1)*dx + offset
               ncold = ncold + 1
               yc(i1,i2,i3)=y0+velyc(i1,i2,i3)/vfact
               pos(2,ncold)=(y0+velyc(i1,i2,i3)/vfact)*hsmall
               if(pos(2,ncold).lt.0) pos(2,ncold) = pos(2,ncold)+Lbox
               if(pos(2,ncold).gt.Lbox) pos(2,ncold) = pos(2,ncold)-Lbox
               pos(2,ncold) = 1000.0 * pos(2,ncold)
               vel(2,ncold)= velyc(i1,i2,i3)
            end do
         end do
      end do
c     Read ref slices of the z velocity field.
      ncold = nbar
      do i3=1,n3
         read(12) ((velzc(i1,i2,i3),i1=1,n1),i2=1,n2)
         do i2=1,n2
            do i1=1,n1
c     Last term centers the top grid at (0,0,0):
               z0=(i3-1)*dx + offset
               ncold = ncold + 1
               zc(i1,i2,i3)=z0+velzc(i1,i2,i3)/vfact
               pos(3,ncold)=(z0+velzc(i1,i2,i3)/vfact)*hsmall
               if(pos(3,ncold).lt.0) pos(3,ncold) = pos(3,ncold)+Lbox
               if(pos(3,ncold).gt.Lbox) pos(3,ncold) = pos(3,ncold)-Lbox
               pos(3,ncold) = 1000.0 * pos(3,ncold)
               vel(3,ncold)= velzc(i1,i2,i3)
            end do
         end do
      end do
c     next ref slices
      close(10)
      close(11)
      close(12)

      do k =1,10000
         write(32,*) pos(1,k),pos(2,k), pos(3,k)
      enddo


c     write these ref slices into GADGET format
c     DEFINE GADGET HEADER
      
      time = astart
      redshift = 1.0/astart  - 1.0
      flag_sfr = 1 !unused integer
      flag_fb =  1 !unused integer
      flag_cooling = 1 !unused integer
      NumFiles = 1 !total number of gadget files
      BoxSize = Lbox*1000.0
      OmegaMatter = omegam
      OmegaLambda = omegav
      HubbleParam = hsmall



c      flag_age = 1 !unused integer
c      flag_metals = 1 !unused integer
c      do i=0,5
c         NallHW(i) = 0
c      enddo
c      flag_entr_ics = 0 !TO BE CHECKED

c     write HADGET Header
      
      open(20,file=outfile,form='unformatted')

      write(20) npart,massarr,time,redshift,flag_sfr,flag_fb,
     $     nall,flag_cooling,NumFiles,BoxSize,OmegaMatter,OmegaLambda,
     $     HubbleParam,unused
      
      ntot =0 
      do k=0,5
         ntot =  ntot + nall(k)
      enddo

      do j=1,ntot
         id(j) = j
      enddo

      do j=1,nbar
         u(j) = 1.0
      enddo

      write(20) ((pos(i,j),i=1,3),j=1,ntot)
      write(20) ((vel(i,j),i=1,3),j=1,ntot)
      write(20) (id(j),j=1,ntot)
      write(20) (u(j),j=1,nbar)

      stop
      end
      
