/*****************************************************************************/
/*                                                                           */
/*              8888888         88888888         88888888                    */
/*            8                8                8                            */
/*           8                 8                8                            */
/*           8                  88888888         88888888                    */
/*           8      8888                8                8                   */
/*            8       8                 8                8                   */
/*              888888         888888888        888888888                    */
/*                                                                           */
/*       A Two-Dimensional General Purpose Semiconductor Simulator.          */
/*                                                                           */
/*  GSS material database Version 0.4                                        */
/*  Last update: Feb 17, 2006                                                */
/*                                                                           */
/*  Gong Ding                                                                */
/*  gdiso@ustc.edu                                                           */
/*  NINT, No.69 P.O.Box, Xi'an City, China                                   */
/*                                                                           */
/*****************************************************************************/
//
// Material Type: Ag


#include "PMI.h"

typedef struct
{
   PetscScalar  wavelength;
   PetscScalar  RefractionIndexRe;
   PetscScalar  RefractionIndexIm;
} table;

//Source: DESSIS data base
static table  Ag[] = {
{0.0506, 0.906,   0.522},
{0.0539, 0.98 ,   0.614},
{0.0551, 1.029,   0.624},
{0.0576, 1.104,   0.584},
{0.059 , 1.109,   0.561},
{0.062 , 1.098,   0.548},
{0.0653, 1.096,   0.565},
{0.0729, 1.121,   0.635},
{0.0775, 1.167,   0.676},
{0.08  , 1.202,   0.691},
{0.0855, 1.281,   0.679},
{0.0918, 1.322,   0.628},
{0.0992, 1.315,   0.588},
{0.1025, 1.308,   0.581},
{0.1051, 1.304,   0.578},
{0.1107, 1.293,   0.566},
{0.1137, 1.28 ,   0.56},
{0.117 , 1.265,   0.56},
{0.1204, 1.252,   0.564},
{0.124 , 1.241,   0.568},
{0.1278, 1.229,   0.566},
{0.1348, 1.182,   0.55},
{0.1378, 1.149,   0.552},
{0.1409, 1.112,   0.563},
{0.1442, 1.073,   0.581},
{0.1476, 1.032,   0.61},
{0.1512, 0.993,   0.653},
{0.155 , 0.962,   0.706},
{0.159 , 0.94 ,   0.77},
{0.1631, 0.935,   0.832},
{0.1675, 0.936,   0.892},
{0.1722, 0.942,   0.951},
{0.1771, 0.953,   1.01},
{0.1823, 0.969,   1.07},
{0.1879, 0.995,   1.13},
{0.1937, 1.028,   1.18},
{0.1968, 1.048,   1.21},
{0.2   , 1.072,   1.24},
{0.2033, 1.098,   1.26},
{0.2066, 1.125,   1.27},
{0.2138, 1.173,   1.29},
{0.2214, 1.208,   1.3},
{0.2296, 1.238,   1.31},
{0.2384, 1.265,   1.33},
{0.248 , 1.298,   1.35},
{0.253 , 1.32 ,   1.35},
{0.2583, 1.343,   1.35},
{0.2638, 1.372,   1.35},
{0.2695, 1.404,   1.33},
{0.2755, 1.441,   1.31},
{0.2818, 1.476,   1.26},
{0.2883, 1.502,   1.19},
{0.2952, 1.519,   1.08},
{0.2988, 1.522,   0.992},
{0.3024, 1.496,   0.882},
{0.3061, 1.432,   0.766},
{0.31  , 1.323,   0.647},
{0.3115, 1.246,   0.586},
{0.3139, 1.149,   0.54},
{0.3155, 1.044,   0.514},
{0.3179, 0.932,   0.504},
{0.3195, 0.815,   0.526},
{0.322 , 0.708,  0.565},
{0.3237, 0.616,   0.609},
{0.3263, 0.526,   0.663},
{0.3306, 0.371,   0.813},
{0.3324, 0.321,   0.902},          
{0.3351, 0.294,   0.986},
{0.3397, 0.259,   1.12},
{0.3444, 0.238,   1.24},
{0.3542, 0.209,   1.44},
{0.3647, 0.2  ,   1.61},
{0.3757, 0.198,   1.67},
{0.3875, 0.192,   1.81},
{0.4   , 0.173,   1.95},
{0.4133, 0.173,   2.11},
{0.4275, 0.16 ,   2.26},
{0.4428, 0.157,   2.4},
{0.4592, 0.144,   2.56},
{0.4769, 0.132,   2.72},
{0.4959, 0.13 ,   2.88},
{0.5166, 0.13 ,   3.07},
{0.5391, 0.129,   3.25},
{0.5636, 0.12 ,   3.45},
{0.5904, 0.121,   3.66},
{0.6199, 0.131,   3.88},
{0.6526, 0.14 ,   4.15},
{0.6888, 0.14 ,   4.44},
{0.7293, 0.148,   4.74},
{0.7749, 0.143,   5.09},
{0.8266, 0.145,   5.5},
{0.8856, 0.163,   5.95},
{0.9537, 0.198,   6.43},
{1.033 , 0.226,   6.99},
{1.127 , 0.251,   7.67},
{1.24  , 0.329,   8.49},
{1.265 , 0.37 ,   7.78},
{1.291 , 0.38 ,   7.92},
{1.305 , 0.38 ,   7.95},
{1.319 , 0.392,   8.06},
{1.348 , 0.401,   8.21},
{1.378 , 0.411,   8.37},
{1.409 , 0.421,   8.37},
{1.459 , 0.44 ,   8.8},
{1.512 , 0.455,   9.08},
{1.55  , 0.469,   9.32},
{1.59  , 0.485,   9.57},
{1.631 , 0.501,   9.84},
{1.675 , 0.519,   10.1},
{1.722 , 0.537,   10.4},
{1.771 , 0.557,   10.7},
{1.823 , 0.578,   11.1},
{1.879 , 0.6  ,   11.4},
{1.937 , 0.624,   11.8},
{2     , 0.65 ,   12.2},
{2.066 , 0.668,   12.6},
{2.138 , 0.729,   13},
{2.214 , 0.774,   13.5},
{2.296 , 0.823,   14},
{2.384 , 0.878,   14.5},
{2.48  , 0.939,   15.1},
{2.583 , 1.007,   15.7},
{2.695 , 1.083,   16.4},
{2.818 , 1.168,   17.1},
{2.952 , 1.265,   17.9},
{3.1   , 1.387,   18.8},
{3.263 , 1.536,   19.8},
{3.444 , 1.71 ,   20.9},
{3.647 , 1.915,   22.1},
{3.875 , 2.16 ,   23.5},
{4.133 , 2.446,   25.1},
{4.428 , 2.786,   26.9},
{4.769 , 3.202,   29},
{5.166 , 3.732,   31.3},
{5.636 , 4.425,   34},
{6.199 , 5.355,   37},
{6.526 , 5.96 ,   38.6},
{6.888 , 6.67 ,   40.4},
{7.293 , 7.461,   42.5},
{7.749 , 8.376,   44.8},
{8.266 , 9.441,   47.1},
{8.856 , 10.69,   49.4},
{9.537 , 12.21,   52.2},
{9.919 , 13.11,   53.7},
{10    , 13.2 ,   54},
{10.001, 13.2 ,   54},
{10.002, 13.2 ,   54},
};

class GSS_Ag_Optical : public PMIC_Optical
{
private:
  int   table_size;
public:
  complex<PetscScalar> RefractionIndex(PetscScalar lamda, PetscScalar Eg=0.0, PetscScalar Tl=1.0) const
  {
    complex<PetscScalar> n(1.0,0.0);
    if(lamda<Ag[0].wavelength) 
      return complex<PetscScalar> (Ag[0].RefractionIndexRe,Ag[0].RefractionIndexIm);
    if(lamda>Ag[table_size-1].wavelength) 
      return complex<PetscScalar> (Ag[table_size-1].RefractionIndexRe,Ag[table_size-1].RefractionIndexIm);
    for(int i=0;i<table_size-1;i++)
    { 
       if(lamda>=Ag[i].wavelength && lamda<=Ag[i+1].wavelength)
       {
          complex<PetscScalar> n1(Ag[i].RefractionIndexRe,Ag[i].RefractionIndexIm);
          complex<PetscScalar> n2(Ag[i+1].RefractionIndexRe,Ag[i+1].RefractionIndexIm);
          PetscScalar d1 = lamda-Ag[i].wavelength;
          PetscScalar d2 = Ag[i+1].wavelength-lamda;
          n = (n1*d2 + n2*d1)/(d1+d2);
          break;  
       }
    }
    return n;   
  }                                            
  
  // constructions
public:
  GSS_Ag_Optical(const PMIC_Environment &env):PMIC_Optical(env)
  {
     table_size = sizeof(Ag)/sizeof(table);
     //the wave length should be scaled
     for(int i=0;i<table_size;i++)
     {
        Ag[i].wavelength*=um;    
     }
  }

  ~GSS_Ag_Optical(){}
}
;

extern "C"
{
  PMIC_Optical*  PMIC_Ag_Optical_Default (const PMIC_Environment& env)
  {
    return new GSS_Ag_Optical(env);
  }
}