/*****************************************************************************/
/*                                                                           */
/*              8888888         88888888         88888888                    */
/*            8                8                8                            */
/*           8                 8                8                            */
/*           8                  88888888         88888888                    */
/*           8      8888                8                8                   */
/*            8       8                 8                8                   */
/*              888888         888888888        888888888                    */
/*                                                                           */
/*       A Two-Dimensional General Purpose Semiconductor Simulator.          */
/*                                                                           */
/*  GSS material database Version 0.4                                        */
/*  Last update: Feb 17, 2006                                                */
/*                                                                           */
/*  Gong Ding                                                                */
/*  gdiso@ustc.edu                                                           */
/*  NINT, No.69 P.O.Box, Xi'an City, China                                   */
/*                                                                           */
/*****************************************************************************/
//
// Material Type: Au


#include "PMI.h"

typedef struct
{
   PetscScalar  wavelength;
   PetscScalar  RefractionIndexRe;
   PetscScalar  RefractionIndexIm;
} table;


//Source: DESSIS data base
static table  Au[] = {
{0.048 ,      0.846,   0.565},
{0.05  ,      0.85 ,   0.645},
{0.052 ,      0.872,   0.74},
{0.054 ,      0.915,   0.825},
{0.056 ,      0.985,   0.848},
{0.058 ,      1.055,   0.842},
{0.06  ,      1.113,   0.813},
{0.062 ,      1.146,   0.77},
{0.064 ,      1.157,   0.73},
{0.066 ,      1.14 ,   0.7},
{0.068 ,      1.107,   0.687},
{0.07  ,      1.075,   0.678},
{0.072 ,      1.05 ,   0.685},
{0.074 ,      1.038,   0.697},
{0.076 ,      1.03 ,   0.713},
{0.078 ,      1.028,   0.73},
{0.08  ,      1.029,   0.745},
{0.082 ,      1.033,   0.759},
{0.084 ,      1.041,   0.77},
{0.086 ,      1.053,   0.78},
{0.088 ,      1.07 ,   0.789},
{0.09  ,      1.09 ,   0.798},
{0.092 ,      1.11 ,   0.806},
{0.094 ,      1.133,   0.812},
{0.096 ,      1.159,   0.819},
{0.098 ,      1.18 ,   0.826},
{0.1   ,      1.2  ,   0.836},
{0.102 ,      1.21 ,   0.848},
{0.104 ,      1.215,   0.86},
{0.106 ,      1.217,   0.87},
{0.108 ,      1.218,   0.885},
{0.11  ,      1.222,   0.9},
{0.112 ,      1.225,   0.914},
{0.114 ,      1.232,   0.927},
{0.116 ,      1.242,   0.935},
{0.118 ,      1.25 ,   0.95},
{0.12  ,      1.26 ,   0.962},
{0.122 ,      1.27 ,   0.975},
{0.124 ,      1.28 ,   0.987},
{0.126 ,      1.29 ,   1},
{0.128 ,      1.3  ,   1.012},
{0.13  ,      1.308,   1.02},
{0.132 ,      1.318,   1.032},
{0.134 ,      1.328,   1.045},
{0.136 ,      1.338,   1.053},
{0.138 ,      1.35 ,   1.063},
{0.14  ,      1.36 ,   1.072},
{0.15  ,      1.419,   1.102},
{0.16  ,      1.483,   1.106},
{0.17  ,      1.519,   1.07},
{0.175 ,      1.5  ,   1.07},
{0.18  ,      1.47 ,   1.085},
{0.185 ,      1.442,   1.107},
{0.19  ,      1.427,   1.135},
{0.195 ,      1.424,   1.17},
{0.2   ,      1.427,   1.215},
{0.2066,      1.422,   1.306},
{0.2101,      1.43 ,   1.334},
{0.2138,      1.432,   1.364},
{0.2175,      1.438,   1.388},
{0.2214,      1.442,   1.418},
{0.2254,      1.452,   1.442},
{0.2296,      1.454,   1.478},
{0.2339,      1.462,   1.51},
{0.2384,      1.47 ,   1.55},
{0.2431,      1.478,   1.59},
{0.248 ,      1.484,   1.636},
{0.253 ,      1.49 ,   1.698},
{0.2583,      1.504,   1.748},
{0.2638,      1.546,   1.784},
{0.2695,      1.598,   1.822},
{0.2755,      1.648,   1.852},
{0.2818,      1.69 ,   1.882},
{0.2883,      1.742,   1.9},
{0.2952,      1.776,   1.918},
{0.3024,      1.812,   1.92},
{0.31  ,      1.83 ,   1.916},
{0.3179,      1.84 ,   1.904},
{0.3263,      1.824,   1.878},
{0.3351,      1.798,   1.86},
{0.3444,      1.766,   1.846},
{0.3542,      1.74 ,   1.848},
{0.3647,      1.716,   1.862},
{0.3757,      1.696,   1.906},
{0.3875,      1.674,   1.936},
{0.4   ,      1.658,   1.956},
{0.4133,      1.636,   1.958},
{0.4275,      1.616,   1.94},
{0.4428,      1.562,   1.904},
{0.4592,      1.426,   1.846},
{0.4769,      1.242,   1.796},
{0.4959,      0.916,   1.84},
{0.5166,      0.608,   2.12},
{0.5391,      0.402,   2.54},
{0.5636,      0.306,   2.88},
{0.6526,      0.166,   3.15},
{0.6888,      0.16 ,   3.8},
{0.7293,      0.164,   4.35},
{0.7749,      0.174,   4.86},
{0.8266,      0.188,   5.39},
{0.8856,      0.21 ,   5.88},
{0.9537,      0.236,   6.47},
{1.033 ,      0.272,   7.07},
{1.127 ,      0.312,   7.93},
{1.265 ,      0.389,   8.09},
{1.291 ,      0.403,   8.25},
{1.319 ,      0.419,   8.42},
{1.384 ,      0.436,   8.59},
{1.378 ,      0.454,   8.77},
{1.409 ,      0.473,   8.96},
{1.442 ,      0.493,   9.15},
{1.476 ,      0.515,   9.36},
{1.512 ,      0.537,   9.58},
{1.55  ,      0.559,   9.81},
{1.59  ,      0.583,   10.1},
{1.631 ,      0.609,   10.3},
{1.675 ,      0.636,   10.6},
{1.722 ,      0.665,   10.9},
{1.771 ,      0.696,   11.2},
{1.823 ,      0.73 ,   11.5},
{1.879 ,      0.767,   11.9},
{1.937 ,      0.807,   12.2},
{2     ,      0.85 ,   12.6},
{2.066 ,      0.896,   13},
{2.138 ,      0.947,   13.4},
{2.214 ,      1.002,   13.9},
{2.296 ,      1.063,   14.4},
{2.384 ,      1.13 ,   14.9},
{2.48  ,      1.205,   15.5},
{2.583 ,      1.287,   16.1},
{2.695 ,      1.379,   16.8},
{2.818 ,      1.482,   17.5},
{2.952 ,      1.598,   18.3},
{3.1   ,      1.728,   19.2},
{3.179 ,      1.8  ,   19.7},
{3.263 ,      1.876,   20.2},
{3.351 ,      1.958,   20.7},
{3.444 ,      2.046,   21.3},
{3.542 ,      2.141,   21.9},
{3.647 ,      2.242,   22.5},
{3.757 ,      2.352,   23.1},
{3.875 ,      2.471,   23.9},
{4     ,      2.6  ,   24.6},
{4.133 ,      2.749,   25.4},
{4.275 ,      2.912,   26.3},
{4.428 ,      3.091,   27.2},
{4.592 ,      3.289,   28.2},
{4.769 ,      3.507,   29.3},
{4.959 ,      3.748,   30.5},
{5.166 ,      4.007,   31.7},
{5.391 ,      4.292,   32.9},
{5.636 ,      4.611,   34.3},
{5.904 ,      4.971,   35.9},
{6.199 ,      5.423,   37.5},
{6.358 ,      5.684,   38.3},
{6.526 ,      5.966,   39.1},
{6.888 ,      6.598,   41},
{7.085 ,      6.937,   42},
{7.293 ,      7.282,   43},
{7.514 ,      7.655,   44.1},
{7.749 ,      8.06 ,   45.2},
{7.999 ,      8.5  ,   46.4},
{8.266 ,      9.016,   47.6},
{8.551 ,      9.582,   48.8},
{8.856 ,      10.21,   50.2},
{9.184 ,      10.84,   51.6},
{9.537 ,      11.51,   53.1},
{9.919 ,      12.24,   54.7},
{10.001,      12.4 ,   55},
};

class GSS_Au_Optical : public PMIC_Optical
{
private:
  int   table_size;
public:
  complex<PetscScalar> RefractionIndex(PetscScalar lamda, PetscScalar Eg=0.0, PetscScalar Tl=1.0) const
  {
    complex<PetscScalar> n(1.0,0.0);
    if(lamda<Au[0].wavelength) 
      return complex<PetscScalar> (Au[0].RefractionIndexRe,Au[0].RefractionIndexIm);
    if(lamda>Au[table_size-1].wavelength) 
      return complex<PetscScalar> (Au[table_size-1].RefractionIndexRe,Au[table_size-1].RefractionIndexIm);
    for(int i=0;i<table_size-1;i++)
    { 
       if(lamda>=Au[i].wavelength && lamda<=Au[i+1].wavelength)
       {
          complex<PetscScalar> n1(Au[i].RefractionIndexRe,Au[i].RefractionIndexIm);
          complex<PetscScalar> n2(Au[i+1].RefractionIndexRe,Au[i+1].RefractionIndexIm);
          PetscScalar d1 = lamda-Au[i].wavelength;
          PetscScalar d2 = Au[i+1].wavelength-lamda;
          n = (n1*d2 + n2*d1)/(d1+d2);
          break;  
       }
    }
    return n;   
  }                                            
  
  // constructions
public:
  GSS_Au_Optical(const PMIC_Environment &env):PMIC_Optical(env)
  {
     table_size = sizeof(Au)/sizeof(table);
     //the wave length should be scaled
     for(int i=0;i<table_size;i++)
     {
        Au[i].wavelength*=um;    
     }
  }

  ~GSS_Au_Optical(){}
}
;

extern "C"
{
  PMIC_Optical*  PMIC_Au_Optical_Default (const PMIC_Environment& env)
  {
    return new GSS_Au_Optical(env);
  }
}
