/*****************************************************************************/
/*                                                                           */
/*              8888888         88888888         88888888                    */
/*            8                8                8                            */
/*           8                 8                8                            */
/*           8                  88888888         88888888                    */
/*           8      8888                8                8                   */
/*            8       8                 8                8                   */
/*              888888         888888888        888888888                    */
/*                                                                           */
/*       A Two-Dimensional General Purpose Semiconductor GaAsmulator.        */
/*                                                                           */
/*  GSS material database Version 0.4                                        */
/*  Last update: Feb 17, 2006                                                */
/*                                                                           */
/*  Gong Ding                                                                */
/*  gdiso@ustc.edu                                                           */
/*  NINT, No.69 P.O.Box, Xi'an City, China                                   */
/*                                                                           */
/*****************************************************************************/
//
// Material Type: InSb


#include "PMI.h"

typedef struct
{
   PetscScalar  wavelength;
   PetscScalar  RefractionIndexRe;
   PetscScalar  RefractionIndexIm;
} table;

//Source: FreeSnell
static table  InSb[] =  {
{0.2296, 1.116,  2.394},    
{0.2322, 1.161,  2.424},    
{0.2339, 1.194,  2.435},    
{0.2366, 1.242,  2.446},    
{0.2384, 1.270,  2.444},    
{0.2412, 1.301,  2.435},    
{0.2431, 1.309,  2.430},    
{0.2460, 1.311,  2.431},    
{0.2480, 1.307,  2.441},    
{0.2510, 1.301,  2.470},    
{0.2530, 1.301,  2.495},    
{0.2562, 1.306,  2.542},    
{0.2583, 1.312,  2.576},    
{0.2616, 1.328,  2.630},    
{0.2638, 1.341,  2.669},    
{0.2672, 1.366,  2.732},    
{0.2695, 1.385,  2.776},    
{0.2731, 1.419,  2.845},    
{0.2755, 1.443,  2.894},    
{0.2792, 1.484,  2.975},    
{0.2818, 1.515,  3.034},    
{0.2857, 1.571,  3.134},    
{0.2883, 1.618,  3.209},    
{0.2924, 1.708,  3.337},    
{0.2952, 1.791,  3.433},    
{0.2995, 1.966,  3.582},    
{0.3024, 2.127,  3.666},    
{0.3069, 2.425,  3.720},    
{0.3100, 2.632,  3.694},    
{0.3147, 2.902,  3.581},    
{0.3179, 3.044,  3.479},    
{0.3229, 3.204,  3.314},    
{0.3263, 3.287,  3.204},    
{0.3315, 3.383,  3.039},    
{0.3351, 3.427,  2.933},    
{0.3406, 3.468,  2.789},    
{0.3444, 3.485,  2.705},    
{0.3502, 3.504,  2.589},    
{0.3542, 3.511,  2.517},    
{0.3604, 3.515,  2.424},    
{0.3647, 3.520,  2.369},    
{0.3712, 3.528,  2.280},    
{0.3757, 3.525,  2.217},    
{0.3827, 3.502,  2.137},    
{0.3875, 3.482,  2.093},    
{0.3949, 3.445,  2.038},    
{0.4000, 3.419,  2.015},    
{0.4078, 3.384,  1.997},    
{0.4133, 3.366,  1.994},    
{0.4217, 3.348,  1.997},    
{0.4275, 3.342,  2.004},    
{0.4366, 3.340,  2.021},    
{0.4428, 3.345,  2.036},    
{0.4525, 3.360,  2.062},    
{0.4592, 3.377,  2.083},    
{0.4696, 3.413,  2.119},    
{0.4769, 3.447,  2.145},    
{0.4881, 3.512,  2.188},    
{0.4959, 3.570,  2.221},    
{0.4999, 3.605,  2.238},    
{0.5040, 3.646,  2.254},
{0.5081, 3.694,  2.271},
{0.5123, 3.752,  2.283},
{0.5166, 3.822,  2.287},
{0.5209, 3.900,  2.274},
{0.5254, 3.976,  2.239},
{0.5299, 4.040,  2.183},
{0.5344, 4.084,  2.121},
{0.5391, 4.111,  2.060},
{0.5438, 4.126,  2.005},
{0.5486, 4.133,  1.957},
{0.5535, 4.136,  1.915},
{0.5585, 4.136,  1.880},
{0.5636, 4.135,  1.850},
{0.5687, 4.134,  1.826},
{0.5740, 4.132,  1.806},
{0.5794, 4.132,  1.790},
{0.5848, 4.133,  1.779},
{0.5904, 4.136,  1.770},
{0.5961, 4.142,  1.765},
{0.6019, 4.149,  1.763},
{0.6078, 4.161,  1.763},
{0.6138, 4.175,  1.767},
{0.6199, 5.194,  1.773},
{0.6262, 4.218,  1.784},
{0.6326, 4.249,  1.799},
{0.6391, 4.290,  1.818},
{0.6458, 4.347,  1.844},
{0.6526, 4.433,  1.873},
{0.6595, 4.566,  1.879},
{0.6666, 4.723,  1.816},
{0.6738, 4.841,  1.685},
{0.6812, 4.898,  1.534},
{0.6888, 4.909,  1.396},
{0.6965, 4.894,  1.275},
{0.7045, 4.867,  1.171},
{0.7126, 4.830,  1.085},
{0.7208, 4.793,  1.010},
{0.7293, 4.754,  0.949},
{0.7380, 4.712,  0.897},
{0.7469, 4.675,  0.848},
{0.7560, 4.637,  0.808},
{0.7653, 4.602,  0.776},
{0.7749, 4.568,  0.749},
{0.7847, 4.534,  0.723},
{0.7948, 4.501,  0.701},
{0.8051, 4.473,  0.675},
{0.8157, 4.442,  0.659},
{0.8266, 4.418,  0.643},
{0.8856, 4.40 ,  0.40 },
{1.033 , 4.24 ,  0.32 },
{1.240 , 4.15 ,  0.26 },
{1.550 , 4.08 ,  0.20 },
{1.6   , 4.081,  0.18 },    
{1.8   , 4.084,  0.17 },    
{2.0   , 4.088,  0.17 },
{2.5   , 4.097,  0.15 },    
{3.0   , 4.105,  0.13 },   
{3.5   , 4.114,  0.12 },    
{4.0   , 4.123,  0.11 },
{4.5   , 4.131,  0.10 },    
{5.0   , 4.14 ,  0.091},    
{6.0   , 4.15 ,  0.074},    
{6.1   , 4.19 ,  0.072}, 
{6.2   , 4.13 ,  0.070},    
{6.3   , 4.25 ,  0.068},    
{6.4   , 4.275,  0.066},    
{6.5   , 4.30 ,  0.063}, 
{6.6   , 4.30 ,  0.059},    
{6.7   , 4.30 ,  0.055},   
{6.8   , 4.30 ,  0.049},    
{6.9   , 4.30 ,  0.037},
};                    
                      
class GSS_InSb_Optical : public PMIS_Optical
{                     
private:              
  int   table_size;   
public:               
  complex<PetscScalar> RefractionIndex(PetscScalar lamda, PetscScalar Eg=1.12, PetscScalar Tl=1.0) const
  {                   
    complex<PetscScalar> n(1.0,0.0);
    if(lamda<InSb[0].wavelength) 
      return complex<PetscScalar> (InSb[0].RefractionIndexRe,InSb[0].RefractionIndexIm);
    if(lamda>InSb[table_size-1].wavelength) 
      return complex<PetscScalar> (InSb[table_size-1].RefractionIndexRe,InSb[table_size-1].RefractionIndexIm);
    for(int i=0;i<table_size-1;i++)
    { 
       if(lamda>=InSb[i].wavelength && lamda<=InSb[i+1].wavelength)
       {
          complex<PetscScalar> n1(InSb[i].RefractionIndexRe,InSb[i].RefractionIndexIm);
          complex<PetscScalar> n2(InSb[i+1].RefractionIndexRe,InSb[i+1].RefractionIndexIm);
          PetscScalar d1 = lamda-InSb[i].wavelength;
          PetscScalar d2 = InSb[i+1].wavelength-lamda;
          n = (n1*d2 + n2*d1)/(d1+d2);
          break;  
       }
    }
    return n;   
  }           

// constructions
public:
  GSS_InSb_Optical(const PMIS_Environment &env):PMIS_Optical(env)
  {
    table_size = sizeof(InSb)/sizeof(table);
    //the wave length should be scaled
    for(int i=0;i<table_size;i++)
    {
        InSb[i].wavelength*=um;    
    }
  }

  ~GSS_InSb_Optical()
  {}
}
;

extern "C"
{
  PMIS_Optical*  PMIS_InSb_Optical_Default (const PMIS_Environment& env)
  {
    return new GSS_InSb_Optical(env);
  }
}

